/**
* \file: LibraryEntryPoint.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include <adit_logging.h>
#include "AlsaAudioOut.h"
#include "AlsaAudioIn.h"
#include "AlsaConfiguration.h"

LOG_DECLARE_CONTEXT(cply);

using namespace adit::carplay;

extern "C" void carplay_LibraryEntryPoint()
{
    // register alsa at logging
    LOG_REGISTER_CONTEXT(cply, "CALS", "CarPlay ALSA audio");
    LOGD_DEBUG((cply, "carplay-alsa git tag: %s", COMP_GIT_VERSION));
    (void)AlsaConfiguration::Instance();

    carplay_FactoryRegister<IAudioOutAdapter, AlsaAudioOut>("AlsaAudioOut");
    carplay_FactoryRegister<IAudioInAdapter, AlsaAudioIn>("AlsaAudioIn");
}

extern "C" void carplay_LibraryExitPoint()
{
    LOG_UNREGISTER_CONTEXT(cply);
}
